// ==UserScript==
// @name         5ch オリジナルアンカージャンプ（オリジナルポップアップ用）新
// @namespace    http://tampermonkey.net/
// @version      1.2
// @description  スレ内アンカーリンクでジャンプ＆ハイライト + AAレスのspan→div変換対応
// @author       ChatGPT
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// ==/UserScript==

(function () {
    'use strict';

    // スクロール時にヘッダーなどの固定要素を避けるためのオフセット（ピクセル単位）
    const offsetPx = 200;

    // ハイライトの背景色と表示時間（ミリ秒）
    const highlightColor = 'rgba(255, 215, 0, 0.8)';
    const highlightDuration = 1500;

    /**
     * アンカーリンク（>>番号）をクリックしたときのスクロールとハイライト処理を有効化
     */
    function enableReplyLinkScroll() {
        document.addEventListener('click', function (event) {
            const link = event.target.closest('a, span.custom_reply'); // 通常リンクまたはカスタムポップアップ用リンク
            if (!link) return;

            let postId = null;

            // 通常のアンカーリンク（例: >>123）
            if (link.tagName.toLowerCase() === 'a') {
                if (!/^>>\d+$/.test(link.textContent)) return;
                postId = link.textContent.replace('>>', '');

            // カスタムポップアップ形式（data-href属性付きのspan）
            } else if (link.classList.contains('custom_reply')) {
                const href = link.getAttribute('data-href');
                if (!href) return;
                const match = href.match(/\/(\d+)$/); // 末尾の数字を抽出
                if (!match) return;
                postId = match[1];
            } else {
                return;
            }

            // リンクの標準動作をキャンセル（ページ内遷移など）
            event.preventDefault();

            // 対象の投稿を data-id 属性から探す
            const target = document.querySelector(`[data-id="${postId}"]`);
            if (!target) {
                console.warn(`data-id="${postId}" の要素が見つかりません`);
                return;
            }

            // 元のスタイルを保存（ハイライト終了後に戻すため）
            const originalBoxShadow = target.style.boxShadow;
            const originalBorderBottom = target.style.borderBottom;
            const originalBorderColor = target.style.borderColor;
            const originalPosition = target.style.position;
            const originalZIndex = target.style.zIndex;

            // スクロール位置を計算してスムーズにスクロール
            const rect = target.getBoundingClientRect();
            const absoluteTop = window.scrollY + rect.top;
            window.scrollTo({
                top: absoluteTop - offsetPx,
                behavior: 'smooth'
            });

            // ハイライトスタイルの適用
            target.style.position = 'relative';
            target.style.zIndex = '10';
            target.style.transition = 'box-shadow 0.5s ease-in-out, border-color 0.3s ease';
            target.style.borderBottom = 'none';
            target.style.boxShadow = `inset 0 -1px 0 0 #eee, 0 0 12px 4px ${highlightColor}`;

            // 指定時間後に元のスタイルに戻す（第1段階）
            setTimeout(() => {
                target.style.boxShadow = originalBoxShadow || '';
                target.style.borderBottom = originalBorderBottom || '1px solid #eee';
                target.style.borderColor = 'transparent';
            }, highlightDuration);

            // 完全に元の状態に戻す（第2段階）
            setTimeout(() => {
                target.style.borderColor = originalBorderColor || 'rgb(238, 238, 238)';
                target.style.position = originalPosition || '';
                target.style.zIndex = originalZIndex || '';
            }, highlightDuration + 500);
        });
    }

    /**
     * ASCIIアート（AA）用のレスで <span> を <div> に置き換え
     * ※ ポップアップが表示される条件の整備（HTML構造の一貫性向上）
     */
    function convertAAToDiv() {
        const aaSpans = document.querySelectorAll('span.AA.custom_reply');
        aaSpans.forEach(span => {
            // 内部にさらに custom_reply を含む場合のみ置き換え（通常のレスはそのまま）
            if (span.querySelector('span.custom_reply')) {
                const div = document.createElement('div');
                div.className = span.className;
                div.setAttribute('data-post-id', span.getAttribute('data-post-id'));
                div.innerHTML = span.innerHTML;
                span.replaceWith(div);
            }
        });
    }

    /**
     * 初期化処理（AA変換とアンカーリンクの有効化）
     */
    function init() {
        convertAAToDiv();           // AAレスのHTML構造調整
        enableReplyLinkScroll();    // アンカーリンクジャンプ機能の有効化
    }

    // DOM が完全に読み込まれたら init 実行（タイミングに応じて分岐）
    if (document.readyState === 'loading') {
        window.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
})();
